

<?php $__env->startSection('title', 'Manage Doctors'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-2 sm:px-4 lg:px-8">
    <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-4 sm:mb-6 gap-3">
        <h1 class="text-2xl sm:text-3xl font-bold text-gray-800">Manage Doctors</h1>
        <div class="flex gap-2">
            <a href="<?php echo e(route('admin.doctors.create')); ?>" class="bg-blue-600 hover:bg-blue-700 text-white px-3 sm:px-4 py-2 rounded text-sm sm:text-base">
                <i class="fas fa-plus"></i> <span class="hidden sm:inline">Register Doctor</span><span class="sm:hidden">Add</span>
            </a>
            <a href="<?php echo e(route('admin.dashboard')); ?>" class="bg-gray-600 hover:bg-gray-700 text-white px-3 sm:px-4 py-2 rounded text-sm sm:text-base">
                <i class="fas fa-arrow-left"></i> <span class="hidden sm:inline">Back to Dashboard</span><span class="sm:hidden">Back</span>
            </a>
        </div>
    </div>

    <?php if(session('success')): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <!-- Quick Filter Buttons -->
    <div class="mb-4 flex flex-wrap gap-2">
        <?php
            $preserveParams = request()->only(['search', 'sort_by', 'sort_order']);
        ?>
        <a href="<?php echo e(route('admin.doctors', $preserveParams)); ?>" 
           class="px-3 py-1 rounded-full text-sm <?php echo e(!request()->has('status') ? 'bg-blue-600 text-white' : 'bg-gray-200 text-gray-700 hover:bg-gray-300'); ?>">
            All (<?php echo e($totalCount); ?>)
        </a>
        <a href="<?php echo e(route('admin.doctors', array_merge($preserveParams, ['status' => 'pending']))); ?>" 
           class="px-3 py-1 rounded-full text-sm <?php echo e(request('status') === 'pending' ? 'bg-red-600 text-white' : 'bg-gray-200 text-gray-700 hover:bg-gray-300'); ?>">
            Pending (<?php echo e($pendingCount); ?>)
        </a>
        <a href="<?php echo e(route('admin.doctors', array_merge($preserveParams, ['status' => 'active']))); ?>" 
           class="px-3 py-1 rounded-full text-sm <?php echo e(request('status') === 'active' ? 'bg-green-600 text-white' : 'bg-gray-200 text-gray-700 hover:bg-gray-300'); ?>">
            Active (<?php echo e($activeCount); ?>)
        </a>
        <a href="<?php echo e(route('admin.doctors', array_merge($preserveParams, ['status' => 'inactive']))); ?>" 
           class="px-3 py-1 rounded-full text-sm <?php echo e(request('status') === 'inactive' ? 'bg-yellow-600 text-white' : 'bg-gray-200 text-gray-700 hover:bg-gray-300'); ?>">
            Inactive (<?php echo e($inactiveCount); ?>)
        </a>
    </div>

    <!-- Search, Sort, and Filter Section -->
    <div class="bg-white rounded-lg shadow p-4 sm:p-6 mb-4 sm:mb-6">
        <form method="GET" action="<?php echo e(route('admin.doctors')); ?>" class="space-y-4">
            <!-- Search Bar -->
            <div class="flex flex-col sm:flex-row gap-3">
                <div class="flex-1">
                    <label class="block text-sm font-medium text-gray-700 mb-1">Search Doctors</label>
                    <div class="relative">
                        <input type="text" 
                               name="search" 
                               value="<?php echo e(request('search')); ?>" 
                               placeholder="Search by name, email, practice number, specialization..." 
                               class="w-full pl-10 pr-4 py-2 border rounded-lg text-sm sm:text-base">
                        <i class="fas fa-search absolute left-3 top-3 text-gray-400"></i>
                        <?php if(request('search')): ?>
                            <button type="button" 
                                    onclick="document.querySelector('input[name=search]').value=''; this.form.submit();" 
                                    class="absolute right-3 top-3 text-gray-400 hover:text-gray-600">
                                <i class="fas fa-times"></i>
                            </button>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Filters and Sort -->
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-3">
                <!-- Status Filter -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Filter by Status</label>
                    <select name="status" class="w-full px-3 py-2 border rounded-lg text-sm sm:text-base">
                        <option value="">All Status</option>
                        <option value="pending" <?php echo e(request('status') === 'pending' ? 'selected' : ''); ?>>
                            Pending
                        </option>
                        <option value="verified" <?php echo e(request('status') === 'verified' ? 'selected' : ''); ?>>
                            Verified
                        </option>
                        <option value="active" <?php echo e(request('status') === 'active' ? 'selected' : ''); ?>>
                            Active
                        </option>
                        <option value="inactive" <?php echo e(request('status') === 'inactive' ? 'selected' : ''); ?>>
                            Inactive
                        </option>
                    </select>
                </div>

                <!-- Sort By -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Sort By</label>
                    <select name="sort_by" class="w-full px-3 py-2 border rounded-lg text-sm sm:text-base">
                        <option value="created_at" <?php echo e(request('sort_by', 'created_at') === 'created_at' ? 'selected' : ''); ?>>Date Registered</option>
                        <option value="name" <?php echo e(request('sort_by') === 'name' ? 'selected' : ''); ?>>Name (A-Z)</option>
                        <option value="email" <?php echo e(request('sort_by') === 'email' ? 'selected' : ''); ?>>Email</option>
                        <option value="practice_number" <?php echo e(request('sort_by') === 'practice_number' ? 'selected' : ''); ?>>Practice Number</option>
                        <option value="status" <?php echo e(request('sort_by') === 'status' ? 'selected' : ''); ?>>Status</option>
                    </select>
                </div>

                <!-- Sort Order -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Order</label>
                    <select name="sort_order" class="w-full px-3 py-2 border rounded-lg text-sm sm:text-base">
                        <option value="desc" <?php echo e(request('sort_order', 'desc') === 'desc' ? 'selected' : ''); ?>>Descending</option>
                        <option value="asc" <?php echo e(request('sort_order') === 'asc' ? 'selected' : ''); ?>>Ascending</option>
                    </select>
                </div>

                <!-- Action Buttons -->
                <div class="flex items-end gap-2">
                    <button type="submit" class="flex-1 bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg text-sm sm:text-base">
                        <i class="fas fa-filter"></i> <span class="hidden sm:inline">Apply</span><span class="sm:hidden">Filter</span>
                    </button>
                    <?php if(request()->hasAny(['search', 'status', 'sort_by', 'sort_order'])): ?>
                        <a href="<?php echo e(route('admin.doctors')); ?>" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg text-sm sm:text-base">
                            <i class="fas fa-times"></i> <span class="hidden sm:inline">Clear</span>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </form>
    </div>

    <!-- Results Count -->
    <?php if(request()->hasAny(['search', 'status', 'sort_by', 'sort_order'])): ?>
        <div class="mb-4 text-sm text-gray-600">
            Showing <?php echo e($doctors->count()); ?> doctor(s)
            <?php if(request('search')): ?>
                matching "<?php echo e(request('search')); ?>"
            <?php endif; ?>
        </div>
    <?php endif; ?>

    <div class="bg-white rounded-lg shadow overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <?php
                            $currentSort = request('sort_by', 'created_at');
                            $currentOrder = request('sort_order', 'desc');
                            
                            function buildSortUrl($sortBy, $currentSort, $currentOrder) {
                                $params = request()->except(['sort_by', 'sort_order']);
                                $params['sort_by'] = $sortBy;
                                $params['sort_order'] = ($currentSort === $sortBy && $currentOrder === 'asc') ? 'desc' : 'asc';
                                return route('admin.doctors', $params);
                            }
                        ?>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">
                            <a href="<?php echo e(buildSortUrl('name', $currentSort, $currentOrder)); ?>" 
                               class="flex items-center hover:text-gray-700">
                                Name
                                <?php if($currentSort === 'name'): ?>
                                    <i class="fas fa-sort-<?php echo e($currentOrder === 'asc' ? 'up' : 'down'); ?> ml-1 text-blue-600"></i>
                                <?php else: ?>
                                    <i class="fas fa-sort ml-1 text-gray-400"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase hidden md:table-cell">
                            <a href="<?php echo e(buildSortUrl('email', $currentSort, $currentOrder)); ?>" 
                               class="flex items-center hover:text-gray-700">
                                Email
                                <?php if($currentSort === 'email'): ?>
                                    <i class="fas fa-sort-<?php echo e($currentOrder === 'asc' ? 'up' : 'down'); ?> ml-1 text-blue-600"></i>
                                <?php else: ?>
                                    <i class="fas fa-sort ml-1 text-gray-400"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">
                            <a href="<?php echo e(buildSortUrl('practice_number', $currentSort, $currentOrder)); ?>" 
                               class="flex items-center hover:text-gray-700">
                                Practice Number
                                <?php if($currentSort === 'practice_number'): ?>
                                    <i class="fas fa-sort-<?php echo e($currentOrder === 'asc' ? 'up' : 'down'); ?> ml-1 text-blue-600"></i>
                                <?php else: ?>
                                    <i class="fas fa-sort ml-1 text-gray-400"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">
                            <a href="<?php echo e(buildSortUrl('status', $currentSort, $currentOrder)); ?>" 
                               class="flex items-center hover:text-gray-700">
                                Status
                                <?php if($currentSort === 'status'): ?>
                                    <i class="fas fa-sort-<?php echo e($currentOrder === 'asc' ? 'up' : 'down'); ?> ml-1 text-blue-600"></i>
                                <?php else: ?>
                                    <i class="fas fa-sort ml-1 text-gray-400"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__empty_1 = true; $__currentLoopData = $doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doctor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="hover:bg-gray-50 cursor-pointer" onclick="window.location='<?php echo e(route('admin.doctors.show', $doctor->id)); ?>'">
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                            <div class="flex items-center">
                                <?php if($doctor->profile_picture_path): ?>
                                    <img src="<?php echo e(asset('storage/' . $doctor->profile_picture_path)); ?>" 
                                         alt="<?php echo e($doctor->full_name); ?>" 
                                         class="h-10 w-10 rounded-full object-cover mr-3 hidden sm:block">
                                <?php else: ?>
                                    <div class="h-10 w-10 rounded-full bg-gray-300 flex items-center justify-center mr-3 hidden sm:block">
                                        <i class="fas fa-user text-gray-600"></i>
                                    </div>
                                <?php endif; ?>
                                <span class="text-sm sm:text-base font-medium"><?php echo e($doctor->full_name); ?></span>
                            </div>
                        </td>
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap hidden md:table-cell">
                            <span class="text-sm"><?php echo e($doctor->email); ?></span>
                        </td>
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                            <span class="text-sm"><?php echo e($doctor->practice_number); ?></span>
                        </td>
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                            <?php if($doctor->is_verified && $doctor->is_active): ?>
                                <span class="px-2 py-1 text-xs rounded-full bg-green-100 text-green-800">Active</span>
                            <?php elseif($doctor->is_verified && !$doctor->is_active): ?>
                                <span class="px-2 py-1 text-xs rounded-full bg-yellow-100 text-yellow-800">Inactive</span>
                            <?php else: ?>
                                <span class="px-2 py-1 text-xs rounded-full bg-red-100 text-red-800">Pending</span>
                            <?php endif; ?>
                        </td>
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap text-sm font-medium" onclick="event.stopPropagation()">
                            <div class="flex flex-col sm:flex-row gap-1 sm:gap-2">
                                <a href="<?php echo e(route('admin.doctors.show', $doctor->id)); ?>" class="text-blue-600 hover:text-blue-900">
                                    <i class="fas fa-eye"></i> <span class="hidden sm:inline">View</span>
                                </a>
                                <a href="<?php echo e(route('admin.doctors.edit', $doctor->id)); ?>" class="text-yellow-600 hover:text-yellow-900">
                                    <i class="fas fa-edit"></i> <span class="hidden sm:inline">Edit</span>
                                </a>
                                <?php if(!$doctor->is_verified): ?>
                                    <form method="POST" action="<?php echo e(route('admin.doctors.verify', $doctor->id)); ?>" class="inline">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="text-green-600 hover:text-green-900">
                                            <i class="fas fa-check"></i> <span class="hidden sm:inline">Verify</span>
                                        </button>
                                    </form>
                                <?php endif; ?>
                                <form method="POST" action="<?php echo e(route('admin.doctors.toggle-status', $doctor->id)); ?>" class="inline">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="text-blue-600 hover:text-blue-900">
                                        <i class="fas fa-toggle-<?php echo e($doctor->is_active ? 'on' : 'off'); ?>"></i> <span class="hidden sm:inline"><?php echo e($doctor->is_active ? 'Deactivate' : 'Activate'); ?></span>
                                    </button>
                                </form>
                                <form method="POST" action="<?php echo e(route('admin.doctors.delete', $doctor->id)); ?>" class="inline" onsubmit="return confirm('Are you sure you want to delete this doctor?')">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="text-red-600 hover:text-red-900">
                                        <i class="fas fa-trash"></i> <span class="hidden sm:inline">Delete</span>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="5" class="px-6 py-8 text-center text-gray-500">
                            <i class="fas fa-user-slash text-4xl mb-2"></i>
                            <p>No doctors found matching your criteria.</p>
                            <?php if(request()->hasAny(['search', 'status'])): ?>
                                <a href="<?php echo e(route('admin.doctors')); ?>" class="text-blue-600 hover:text-blue-900 mt-2 inline-block">
                                    Clear filters
                                </a>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\BrainTech\Documents\BEAUTEZ SYSTEM\resources\views/admin/doctors.blade.php ENDPATH**/ ?>